-- Alligator Sniper by Currenthill

GT = {};
GT_t.ws = 0;
set_recursive_metatable(GT, GT_t.generic_human);
set_recursive_metatable(GT.chassis, GT_t.CH_t.HUMAN);
set_recursive_metatable(GT.armour_scheme, GT_t.unarmed_armour_scheme);

GT.visual.shape = "Alligator_Sniper";
GT.visual.shape_dstr = "Alligator_Sniper_dest";

GT.toggle_alarm_state_interval = 1.0;

GT.mobile = false;

GT.IR_emission_coeff = 0.002

GT.AddPropVehicle = {
			{ id = "Camouflage cover" , control = 'checkbox', label = _('Camouflage cover'), defValue = false, arg=250, boolean_inverted = false} -- boolean_inverted = true by default: element present - argVal=0, absent - argVal=1
		}

GT.sensor = {};
set_recursive_metatable(GT.sensor, GT_t.SN_visual);
GT.sensor.max_range_finding_target = 5000;
GT.sensor.min_range_finding_target = 0;
GT.sensor.max_alt_finding_target = 1500;
GT.sensor.height = 10.0;

GT.WS = {};
GT.WS.maxTargetDetectionRange = 5000;
GT.WS.fire_on_march = false;

-- =========================== CARTRIDGES =======================================

declare_weapon({
	category 				= CAT_SHELLS,
	name 					= "Alligator_14_5_API", 
	user_name 				= _("14.5 mm API"),
	model_name    			= "tracer_bullet_green",
	projectile				= "AP",
	v0    					= 1200.0,
	Dv0   					= 0.0010,
	Da0     				= 0.0001,
	Da1     				= 0.0,
	mass      				= 0.094,
	explosive     			= 0.094,
	life_time     			= 11,
	caliber    				= 14.5,
	AP_cap_caliber 			= 25.0,	
	s         				= 0.0,
	j         				= 0.0,
	l         				= 0.0,
	charTime    			= 0,
	cx        				= {0,0.68,0.75,0.27,2.0},
	k1        				= 9.7e-09,
	tracer_off    			= -1,
	scale_tracer  			= 1,
	cartridge 				= 0,
	
});

declare_weapon({
	category 				= CAT_SHELLS,
	name 					= "Alligator_14_5_HEI", 
	user_name 				= _("14.5 mm HEI"),
	model_name    			= "tracer_bullet_green",
    projectile      		= "HE",
    payloadEffect   		= "Fragmentation",
    payloadMaterial 		= "RDX",	
	v0    					= 1000.0,
	Dv0   					= 0.0010,
	Da0     				= 0.0001,
	Da1     				= 0.0,
	mass      				= 0.194,
	explosive     			= 0.194,
	life_time     			= 11,
	caliber    				= 14.5,
	s         				= 0.0,
	j         				= 0.0,
	l         				= 0.0,
	charTime    			= 0,
	cx        				= {0,0.68,0.75,0.27,2.0},
	k1        				= 9.7e-09,
	tracer_off    			= -100,
	scale_tracer  			= 1,
	cartridge 				= 0,
	
});

-- ======================== RIFLE DEFINITION ==============================================

GT_t.LN_t.snipex_alligator = {name = "Snipex Alligator", display_name = _("Snipex Alligator")}
GT_t.LN_t.snipex_alligator.type = 3
GT_t.LN_t.snipex_alligator.distanceMin = 1
GT_t.LN_t.snipex_alligator.distanceMax = 3000
GT_t.LN_t.snipex_alligator.max_trg_alt = 1500
GT_t.LN_t.snipex_alligator.reactionTime = 2.0
GT_t.LN_t.snipex_alligator.sensor = {}
set_recursive_metatable(GT_t.LN_t.snipex_alligator.sensor, GT_t.WSN_t[7])
GT_t.LN_t.snipex_alligator.PL = {}
GT_t.LN_t.snipex_alligator.PL[1] = {}
GT_t.LN_t.snipex_alligator.PL[1].ammo_capacity = 5
GT_t.LN_t.snipex_alligator.PL[1].switch_on_delay = 4.0;
GT_t.LN_t.snipex_alligator.PL[1].reload_time = 4.0;
GT_t.LN_t.snipex_alligator.PL[1].portionAmmoCapacity = 5;
GT_t.LN_t.snipex_alligator.PL[1].shell_name = {"Alligator_14_5_API"};
GT_t.LN_t.snipex_alligator.PL[1].shot_delay = 5.0
GT_t.LN_t.snipex_alligator.BR = { {pos = {5.2, 0, 0} } }
for i=2,10 do
    GT_t.LN_t.snipex_alligator.PL[i] = {};
    set_recursive_metatable(GT_t.LN_t.snipex_alligator.PL[i], GT_t.LN_t.snipex_alligator.PL[1]);
end;

-- =========================== Snipex Alligator 14.5 mm anti material rifle ===========================================================

ws = GT_t.inc_ws();
GT.WS[ws] = {}
GT.WS[ws].center = 'CENTER_TOWER_01';
GT.WS[ws].pointer = "POINT_SIGHT"; 
GT.WS[ws].cockpit = {'GPS/GPS', {0.0, 0.0, 0.0 }}
GT.WS[ws].drawArgument1 = 0
GT.WS[ws].drawArgument2 = 1 
GT.WS[ws].omegaY = math.rad(60);
GT.WS[ws].omegaZ = math.rad(60);
GT.WS[ws].pidY = {p=100,i=1.5,d=9,inn=10};
GT.WS[ws].pidZ = {p=100,i=1.5,d=9,inn=10,};
GT.WS[ws].laser = true;
GT.WS[ws].angles = {
                    {math.rad(180), math.rad(-180), math.rad(-5), math.rad(5)},
                    };
GT.WS[ws].reference_angle_Z = math.rad(0);
GT.WS[ws].reference_angle_Y = math.rad(0);	
				
__LN = add_launcher(GT.WS[ws], GT_t.LN_t.snipex_alligator);
__LN.BR[1] = { connector_name = 'POINT_GUN_01', 
							recoilArgument = 20,
							recoilTime = 0.25, alternativeRecoil = true,
							reloadArgument = 70, reloadAnimDelay = 0.6, reloadDuration = 3.0,
							muzzleBrakeType = 3,
							}
__LN.createMuzzleFlashEffect = true;							
__LN.sightMasterMode = 1;
__LN.sightIndicationMode = 1;

-- =====================================================================================

GT.Name = "CH_Alligator_Sniper";
GT.DisplayName = _("[CH] Alligator Sniper AMR");
GT.DisplayNameShort = _('Alligator Sniper AMR');
GT.Rate = 5;

GT.Sensors = { 
	Mount_WS_ID = 1,
	OPTIC = {"EMES 15 day", "EMES 15 night",},
	noVisualDetectorInAlarmedState = false	                
				};
				
GT.EPLRS = true

GT.Transportable = {
		size = 100
	};

GT.DetectionRange = 5000;
GT.ThreatRange = 3000;
GT.mapclasskey = "P0091000201";
GT.attribute = {wsType_Ground,wsType_Tank,wsType_Gun,wsType_GenericInfantry,
				"Infantry",
				};
GT.category = "Infantry";

GT.Countries = {"Ukraine"}
